/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.client.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.yollo.dmlreforged.common.items.ItemDeepLearner;
import com.yollo.dmlreforged.common.mobmetas.DragonMeta;
import com.yollo.dmlreforged.common.mobmetas.EndermanMeta;
import com.yollo.dmlreforged.common.mobmetas.GhastMeta;
import com.yollo.dmlreforged.common.mobmetas.MobMetaData;
import com.yollo.dmlreforged.common.mobmetas.SlimeMeta;
import com.yollo.dmlreforged.common.mobmetas.SpiderMeta;
import com.yollo.dmlreforged.common.mobmetas.WitchMeta;
import com.yollo.dmlreforged.common.mobmetas.WitherMeta;
import com.yollo.dmlreforged.core.container.DeepLearnerContainer;
import com.yollo.dmlreforged.core.util.DataModelHelper;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DeepLearnerScreen
extends AbstractContainerScreen<DeepLearnerContainer> {
    public static final int WIDTH = 338;
    public static final int HEIGHT = 235;
    protected ItemStack deepLearner;
    private InteractionHand hand;
    private MobMetaData meta;
    private Level world;
    private NonNullList<ItemStack> validDataModels;
    private int currentItem = 0;
    private PoseStack pose;
    private ImageButton imgBtnPrev;
    private ImageButton imgBtnNext;
    private static final ResourceLocation base = new ResourceLocation("dmlreforged", "textures/gui/deeplearner_base.png");
    private static final ResourceLocation extras = new ResourceLocation("dmlreforged", "textures/gui/deeplearner_extras.png");
    private static final ResourceLocation defaultGui = new ResourceLocation("dmlreforged", "textures/gui/default_gui.png");

    public DeepLearnerScreen(DeepLearnerContainer container, Inventory playerInv, Component component) {
        super((AbstractContainerMenu)container, playerInv, component);
        this.world = playerInv.f_35978_.f_19853_;
        this.hand = playerInv.f_35978_.m_21205_().m_41720_() instanceof ItemDeepLearner ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.deepLearner = playerInv.f_35978_.m_21120_(this.hand);
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.pose = pose;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)base);
        this.m_93228_(pose, left - 41, top - 36, 0, 0, 256, 140);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)defaultGui);
        this.m_93228_(pose, left + 0, top + 111, 0, 0, 176, 90);
        NonNullList<ItemStack> list = ItemDeepLearner.getContainedItems(this.deepLearner);
        this.validDataModels = DataModelHelper.getValidFromList(list);
        if (this.validDataModels.size() > 1) {
            if (this.f_169369_.size() < 2) {
                this.renderCycleButtons(pose, left, top);
            }
        } else {
            this.m_169411_((GuiEventListener)this.imgBtnNext);
            this.m_169411_((GuiEventListener)this.imgBtnPrev);
        }
        if (this.validDataModels.size() >= 1 && this.currentItem <= this.validDataModels.size()) {
            int fixPos = this.validDataModels.size() - 1 - this.currentItem < 0 ? this.validDataModels.size() - 1 : this.validDataModels.size() - 1 - this.currentItem;
            this.meta = DataModelHelper.getMobMetaData((ItemStack)this.validDataModels.get(this.validDataModels.size() >= 1 ? fixPos : this.currentItem));
            this.renderMetaDataText(this.meta, left, top, (ItemStack)this.validDataModels.get(fixPos), pose);
            this.renderMobDisplayBox(pose, left, top);
            DeepLearnerScreen.renderEntityInInventory(this.getGuiLeft() - 85, this.getGuiTop() + 52, 30, partialTicks, this.meta, this.world);
        } else {
            this.renderDefaultScreen(pose);
        }
    }

    public void m_6305_(PoseStack p_97795_, int p_97796_, int p_97797_, float p_97798_) {
        this.m_7333_(p_97795_);
        super.m_6305_(p_97795_, p_97796_, p_97797_, p_97798_);
        this.m_7025_(p_97795_, p_97796_, p_97797_);
    }

    private void renderDefaultScreen(PoseStack pose) {
        int leftStart = this.getGuiLeft() - 32;
        int top = this.getGuiTop() - 32;
        int spacing = 12;
        DeepLearnerScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)new TranslatableComponent("dmlreforged.gui.deep_learner.not_found"), (int)leftStart, (int)(top + spacing), (int)0x55FFFF);
        DeepLearnerScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)new TranslatableComponent("dmlreforged.gui.deep_learner.insert"), (int)leftStart, (int)(top + spacing * 2), (int)0xFFFFFF);
        DeepLearnerScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)new TranslatableComponent("dmlreforged.gui.deep_learner.collect_data"), (int)leftStart, (int)(top + spacing * 3), (int)0xFFFFFF);
        DeepLearnerScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)new TranslatableComponent("dmlreforged.gui.deep_learner.when_placed"), (int)leftStart, (int)(top + spacing * 4), (int)0xFFFFFF);
        DeepLearnerScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)new TranslatableComponent("dmlreforged.gui.deep_learner.in_order"), (int)leftStart, (int)(top + spacing * 6), (int)0xFFFFFF);
        DeepLearnerScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)new TranslatableComponent("dmlreforged.gui.deep_learner.killing_blow"), (int)leftStart, (int)(top + spacing * 7), (int)0xFFFFFF);
    }

    private void renderMetaDataText(MobMetaData meta, int left, int top, ItemStack stack, PoseStack pose) {
        DecimalFormat f = new DecimalFormat("0.#");
        int leftStart = this.getGuiLeft() - 32;
        int topStart = top - 40;
        int spacing = 12;
        DeepLearnerScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)"Name", (int)leftStart, (int)(topStart + spacing), (int)0x55FFFF);
        DeepLearnerScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)("The " + meta.getName()), (int)leftStart, (int)(topStart + spacing * 2), (int)0xFFFFFF);
        DeepLearnerScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)"Information", (int)leftStart, (int)(topStart + spacing * 3), (int)0xFFFFFF);
        String[] mobTrivia = meta.getMobTrivia();
        for (int i = 0; i < mobTrivia.length; ++i) {
            DeepLearnerScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)mobTrivia[i], (int)leftStart, (int)(topStart + spacing * 3 + (i + 1) * 12), (int)0xFFFFFF);
        }
        MutableComponent dataModelTier = DataModelHelper.getTierName(stack, false);
        MutableComponent nextTier = DataModelHelper.getTierName(stack, true);
        String pluralMobName = DataModelHelper.getMobMetaData(stack).getPluralName();
        int totalKills = DataModelHelper.getTotalKillCount(stack);
        double killsToNextTier = DataModelHelper.getKillsToNextTier(stack);
        DeepLearnerScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)new TranslatableComponent("dmlreforged.tiers.tier", new Object[]{dataModelTier}), (int)leftStart, (int)(topStart + spacing * 8), (int)0xFFFFFF);
        DeepLearnerScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)(pluralMobName + " defeated: " + totalKills), (int)leftStart, (int)(topStart + spacing * 9), (int)0xFFFFFF);
        if (DataModelHelper.getTier(stack) != 4) {
            DeepLearnerScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)new TranslatableComponent("dmlreforged.tiers.tier_next", new Object[]{f.format(killsToNextTier), nextTier}), (int)leftStart, (int)(topStart + spacing * 10), (int)0xFFFFFF);
        } else {
            DeepLearnerScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)new TranslatableComponent("dmlreforged.gui.deep_learner.max"), (int)leftStart, (int)(topStart + spacing * 10), (int)0xFFFFFF);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)base);
        this.m_93228_(pose, left + 154, topStart + spacing * 2 - 2, 0, 140, 9, 9);
        DeepLearnerScreen.m_93243_((PoseStack)pose, (Font)this.f_96547_, (Component)new TranslatableComponent("dmlreforged.gui.deep_learner.hp"), (int)(left + 154), (int)(topStart + spacing), (int)0x55FFFF);
        int numOfHearts = meta.getNumberOfHearts();
        if (numOfHearts == 0) {
            DeepLearnerScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)"\ufffdk10\ufffdr", (int)(left + 164), (int)(topStart + spacing * 2 - 1), (int)0xFFFFFF);
        } else {
            DeepLearnerScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)("" + meta.getNumberOfHearts()), (int)(left + 164), (int)(topStart + spacing * 2 - 1), (int)0xFFFFFF);
        }
    }

    private void renderCycleButtons(PoseStack pose, int left, int top) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)extras);
        this.imgBtnPrev = new ImageButton(this.getGuiLeft() - 84, this.getGuiTop() + 70, 24, 24, 99, 0, 24, extras, 255, 255, btn -> {
            if (this.validDataModels.size() > 1) {
                this.currentItem = this.nextItemIndex();
            }
        });
        this.imgBtnNext = new ImageButton(this.getGuiLeft() - 110, this.getGuiTop() + 70, 24, 24, 75, 0, 24, extras, 255, 255, btn -> {
            if (this.validDataModels.size() > 1) {
                this.currentItem = this.previousItemIndex();
            }
        });
        this.m_142416_((GuiEventListener)this.imgBtnNext);
        this.m_142416_((GuiEventListener)this.imgBtnPrev);
    }

    private void renderMobDisplayBox(PoseStack pose, int left, int top) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)extras);
        this.m_93228_(pose, left - 123, top - 36, 0, 0, 75, 101);
    }

    protected void m_7027_(PoseStack p_97808_, int p_97809_, int p_97810_) {
    }

    public NonNullList<ItemStack> getItemStacks() {
        NonNullList list = NonNullList.m_122779_();
        int numOfSlots = 4;
        for (int i = 0; i < numOfSlots; ++i) {
            list.add(i, (Object)((DeepLearnerContainer)this.m_6262_()).m_38853_(i).m_7993_());
        }
        return list;
    }

    public Component m_96636_() {
        return super.m_96636_();
    }

    protected void m_6597_(Slot slot, int dragType, int index, ClickType clickTypeIn) {
        this.validDataModels = DataModelHelper.getValidFromList(ItemDeepLearner.getContainedItems(this.deepLearner));
        if (this.validDataModels.size() >= 1 && this.currentItem < this.validDataModels.size()) {
            this.meta = DataModelHelper.getMobMetaData((ItemStack)this.validDataModels.get(this.currentItem));
            this.renderMetaDataText(this.meta, this.getGuiLeft(), this.getGuiTop(), (ItemStack)this.validDataModels.get(this.currentItem), this.pose);
            if (slot != null && slot.m_7993_().m_41619_()) {
                this.nextItemIndex();
            }
        }
        ((DeepLearnerContainer)this.m_6262_()).getDeepInv().m_6596_();
        super.m_6597_(slot, dragType, index, clickTypeIn);
    }

    public static void renderEntityInInventory(int xPos, int yPos, int scale, float partialTicks, MobMetaData meta, Level world) {
        Quaternion quaternion;
        Quaternion quaternion1;
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)xPos, (double)yPos + Math.sin((double)world.m_46467_() / 13.0) * 3.0, 1050.0);
        LivingEntity entity = meta.getEntity(world);
        if (meta instanceof DragonMeta) {
            posestack.m_85841_(0.19f, 0.19f, -0.19f);
            quaternion1 = Vector3f.f_122223_.m_122240_(10.0f);
            quaternion = Vector3f.f_122227_.m_122240_(180.0f);
            posestack.m_85837_((double)xPos - 67.0, (double)yPos - 200.0 + Math.sin((double)world.m_46467_() / 13.0) * 3.0, 1050.0);
        } else if (meta instanceof WitherMeta) {
            posestack.m_85841_(0.7f, 0.7f, -0.7f);
            quaternion1 = Vector3f.f_122223_.m_122240_(180.0f);
            quaternion = Vector3f.f_122227_.m_122240_(0.0f);
            posestack.m_85837_((double)(xPos - 68), (double)(yPos - 87) + Math.sin((double)world.m_46467_() / 13.0) * 3.0, 1050.0);
        } else if (meta instanceof GhastMeta) {
            posestack.m_85841_(0.33f, 0.33f, -0.33f);
            quaternion1 = Vector3f.f_122223_.m_122240_(180.0f);
            quaternion = Vector3f.f_122227_.m_122240_(0.0f);
            posestack.m_85837_((double)(xPos - 68), (double)(yPos - 188) + Math.sin((double)world.m_46467_() / 13.0) * 0.001, 0.0);
        } else if (meta instanceof SpiderMeta) {
            posestack.m_85841_(1.02f, 1.02f, -1.02f);
            quaternion1 = Vector3f.f_122223_.m_122240_(180.0f);
            quaternion = Vector3f.f_122227_.m_122240_(0.0f);
            posestack.m_85837_((double)(xPos - 68), (double)(yPos - 110) + Math.sin((double)world.m_46467_() / 13.0) * 3.0, 0.0);
        } else if (meta instanceof WitchMeta) {
            posestack.m_85841_(1.2f, 1.2f, -1.2f);
            quaternion1 = Vector3f.f_122223_.m_122240_(180.0f);
            quaternion = Vector3f.f_122227_.m_122240_(0.0f);
            posestack.m_85837_((double)(xPos - 68), (double)(yPos - 97) + Math.sin((double)world.m_46467_() / 13.0) * 0.001, 0.0);
        } else if (meta instanceof EndermanMeta) {
            posestack.m_85841_(1.02f, 1.02f, -1.02f);
            quaternion1 = Vector3f.f_122223_.m_122240_(180.0f);
            quaternion = Vector3f.f_122227_.m_122240_(0.0f);
            posestack.m_85837_((double)(xPos - 68), (double)(yPos - 99) + Math.sin((double)world.m_46467_() / 13.0) * 1.0E-5, 0.0);
        } else if (meta instanceof SlimeMeta) {
            posestack.m_85841_(2.0f, 2.0f, -2.0f);
            quaternion1 = Vector3f.f_122223_.m_122240_(180.0f);
            quaternion = Vector3f.f_122227_.m_122240_(0.0f);
            posestack.m_85837_((double)(xPos - 68), (double)(yPos - 110) + Math.sin((double)world.m_46467_() / 13.0) * 3.0, 0.0);
        } else {
            posestack.m_85841_(1.2f, 1.2f, -1.2f);
            quaternion1 = Vector3f.f_122223_.m_122240_(180.0f);
            quaternion = Vector3f.f_122227_.m_122240_(0.0f);
        }
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85837_(0.0, 0.0, 1000.0);
        posestack1.m_85841_((float)scale, (float)scale, (float)scale);
        quaternion.m_80148_(quaternion1);
        posestack1.m_85845_(quaternion);
        entity.f_20883_ = 0.0f + (float)((double)world.m_46467_() * 1.2);
        entity.f_20885_ = 0.0f + (float)((double)world.m_46467_() * 1.2);
        if (entity instanceof WitherBoss) {
            WitherBoss wither = (WitherBoss)entity;
            wither.f_31424_[0] = 0.0f + (float)((double)world.m_46467_() * 1.2);
            wither.f_31424_[1] = 0.0f + (float)((double)world.m_46467_() * 1.2);
        }
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        entityrenderdispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0));
        multibuffersource$buffersource.m_109911_();
        entityrenderdispatcher.m_114468_(true);
        entity.f_20883_ = 0.0f;
        entity.f_20885_ = 0.0f;
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    private int nextItemIndex() {
        int result = this.currentItem == this.validDataModels.size() - 1 ? 0 : this.currentItem + 1;
        return result;
    }

    private int previousItemIndex() {
        int result = this.currentItem == 0 ? (this.validDataModels.size() > 1 ? this.validDataModels.size() - 1 : 0) : this.currentItem - 1;
        return result;
    }
}

